#include<bits/stdc++.h>
using namespace std;
using ll = long long;
using ld = long double;
const ll M = 1e9 + 7;

struct r {
    ll x, y;
};

struct otr {
    r a, b;
};

r operator+ (r a, r b) {
    r res;
    res.x = a.x + b.x;
    res.y = a.y + b.y;
    return res;
}

r operator- (r a, r b) {
    r res;
    res.x = a.x - b.x;
    res.y = a.y - b.y;
    return res;
}

ll operator* (r a, r b) {
    return a.x * b.x + a.y * b.y;
}

ll operator^ (r a, r b) {
    return a.x * b.y - a.y * b.x;
}

void f(ll &x) {
    if (x >= 1) x = 1;
    if (x == 0) x = 0;
    if (x <= -1) x = -1;
}

bool is_per(otr a, otr b) {
    if (a.a.x == b.a.x && a.a.y == b.a.y) {
        return true;
    }
    if (a.a.x == b.b.x && a.a.y == b.b.y) {
        return true;
    }
    if (a.b.x == b.a.x && a.b.y == b.a.y) {
        return true;
    }
    if (a.b.x == b.b.x && a.b.y == b.b.y) {
        return true;
    }
    bool f1 = false, f2 = false;
    ll v1 = (a.a - b.b) ^ (b.a - b.b);
    ll v2 = (a.b - b.b) ^ (b.a - b.b);
    ll v3 = (b.a - a.a) ^ (a.b - a.a);
    ll v4 = (b.b - a.a) ^ (a.b - a.a);
    f(v1); f(v2); f(v3); f(v4);
    if (v1 * v2 <= 0 && v3 * v4 <= 0) f1 = true;
    if (v3 * v4 <= 0 && v1 * v2 <= 0) f1 = true;
    if (v1 == 0 && v2 == 0 && v3 == 0 && v4 == 0) f1 = false;
    return f1;
}

vector<vector<int>> g;
vector<bool> used;
int R, V;

void dfs(int v) {
    used[v] = true;
    R += g[v].size();
    V += 1;
    for (auto to: g[v]) {
        if (!used[to]) {
            dfs(to);
        }
    }
}

void solve() {
    int n;
    cin >> n;
    g.clear();
    used.clear();
    g.resize(n);
    used.resize(n, false);
    vector<otr> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i].a.x >> a[i].a.y >> a[i].b.x >> a[i].b.y;
    }
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < i; j++) {
            if (is_per(a[i], a[j])) {
                g[i].push_back(j);
                g[j].push_back(i);
            }
        }
    }
    int cnt = 1;
    for (int i = 0; i < n; i++) {
        if (!used[i]) {
            R = 0;
            V = 0;
            dfs(i);
            R /= 2;
            cnt += 1 - V + R;
        }
    }
    cout << cnt << endl;
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0); cout.tie(0);

    int tc;
    cin >> tc;
    while (tc--) {
        solve();
    }
    return 0;
}
